Imports System.IO
Imports MySql.Data
Imports MySql.Data.MySqlClient
Imports System.Data

Partial Class Select_MySQL
    Inherits System.Web.UI.Page
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        ' When the page loads we get data from session variables to us in our select statements

        If Page.IsPostBack = False Then
            HiddenCompanyID.Value = Session("CompanyID")
            HiddenYearID.Value = Session("YearID")
            HiddenCompanyName.Value = Session("CompanyName")
        End If
    End Sub
    Protected Sub BtnSelectAssets_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles BtnSelectAssets.Click

        ' This is code to select data to a dataset with two tables so that we kan make groups and calculate values.
        ' Asset accounts are inserted in parentrepeater and assets are inserted inside a childrepeater.

        Try
            Dim ConnString As String = ConfigurationManager.ConnectionStrings("ConnectionString").ToString()
            Dim sql As String = "SELECT AssetTypeID, AssetAccount, TypeName FROM AssetType WHERE CompanyID = @CompanyID GROUP BY AssetTypeID, AssetAccount, TypeName ORDER BY AssetAccount ASC"
            Dim sql2 As String = "SELECT A.AssetOwnID, A.AssetType, A.AssetName, A.PurchaseDate, A.PurchasePrice, SUM(COALESCE(SumIB, 0)) As YearIB, SUM(COALESCE(SumYearDep,0)) As YearDep, SUM(COALESCE(SumIB, 0) + COALESCE(SumYearDep,0)) As SumAckDeprication, SUM(A.PurchasePrice - (COALESCE(SumIB, 0) + COALESCE(SumYearDep,0))) As AccountedValue FROM Assets AS A LEFT OUTER JOIN (SELECT AssetID, SUM(IBValue) As SumIB FROM IBDeprication WHERE YearID = @YearID GROUP BY AssetID) As IB ON A.AssetID = IB.AssetID LEFT OUTER JOIN (SELECT AssetID, SUM(DepricationValue) As SumYearDep FROM Deprication WHERE YearID = @YearID GROUP BY AssetID) AS D ON A.AssetID = D.AssetID WHERE A.CompanyID = @CompanyID AND A.SoldScraped = '0' OR A.DateSold > @Slutdatum GROUP BY A.AssetOwnID, A.AssetType, A.AssetName, A.PurchaseDate, A.PurchasePrice ORDER BY A.PurchaseDate ASC"

            ' The Using block is used to call dispose (close) automatically even if there are an exception.
            Using cn As New MySqlConnection(ConnString), _
                ad As New MySqlDataAdapter(), _
                cmd As New MySqlCommand(sql, cn), _
                ad2 As New MySqlDataAdapter(), _
                cmd2 As New MySqlCommand(sql2, cn)
                cmd.Parameters.Add("@CompanyID", MySqlDbType.Int64).Value = HiddenCompanyID.Value
                cmd2.Parameters.Add("@YearID", MySqlDbType.Int64).Value = HiddenYearID.Value
                cmd2.Parameters.Add("@CompanyID", MySqlDbType.Int64).Value = HiddenCompanyID.Value
                cmd2.Parameters.Add("@Slutdatum", MySqlDbType.Date).Value = txtEndDate.Text

                cn.Open()

                ' Fill dataset with assettypes as first table
                ad.SelectCommand = cmd

                ' The Using block is used to call dispose (close) automatically even if there are an exception.
                Using ds As New DataSet()

                    ad.Fill(ds, "AssetTypes")

                    ' Fill dataset with assets as second table
                    ad2.SelectCommand = cmd2
                    ad2.Fill(ds, "Assets")

                    ' Create the relation bewtween the AssetTypes and Assets tables.
                    ds.Relations.Add("assetsrelation", ds.Tables("AssetTypes").Columns("AssetTypeID"), ds.Tables("Assets").Columns("AssetType"))

                    ' Calculate subtotals
                    Dim PPTotal As DataColumn = New DataColumn("PPTotalt", System.Type.GetType("System.Decimal"), "Sum(Child(assetsrelation).PurchasePrice)")
                    PPTotal.AutoIncrement = False
                    PPTotal.ReadOnly = True
                    Dim IBTotal As DataColumn = New DataColumn("IBtotalt", System.Type.GetType("System.Decimal"), "Sum(Child(assetsrelation).YearIB)")
                    IBTotal.AutoIncrement = False
                    IBTotal.ReadOnly = True
                    Dim YearTotal As DataColumn = New DataColumn("YearDepTotalt", System.Type.GetType("System.Decimal"), "Sum(Child(assetsrelation).YearDep)")
                    YearTotal.AutoIncrement = False
                    YearTotal.ReadOnly = True
                    Dim AckDepTotal As DataColumn = New DataColumn("AckDepTotalt", System.Type.GetType("System.Decimal"), "Sum(Child(assetsrelation).SumAckDeprication)")
                    AckDepTotal.AutoIncrement = False
                    AckDepTotal.ReadOnly = True
                    Dim AccValueTotal As DataColumn = New DataColumn("AccValueTotalt", System.Type.GetType("System.Decimal"), "Sum(Child(assetsrelation).AccountedValue)")
                    AccValueTotal.AutoIncrement = False
                    AccValueTotal.ReadOnly = True

                    ' Add columns to table AssetTypes
                    ds.Tables("AssetTypes").Columns.Add(PPTotal)
                    ds.Tables("AssetTypes").Columns.Add(IBTotal)
                    ds.Tables("AssetTypes").Columns.Add(YearTotal)
                    ds.Tables("AssetTypes").Columns.Add(AckDepTotal)
                    ds.Tables("AssetTypes").Columns.Add(AccValueTotal)

                    ' Bind the AssetTypes table to the parentrepeater control, and call DataBind. Data for the 
                    ' childrepeater gets in Repeater.aspx from the dataset.
                    parentRepeater.DataSource = ds.Tables("AssetTypes")
                    Page.DataBind()
                End Using

            End Using
        Catch ex As Exception
            Response.Write(ex.Message)
        End Try
    End Sub
    Protected Sub ImportIB_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles ImportIB.Click

        ' When the user clicks the button to import opening balance we select opening balance from the database
        ' and bind the data to a repeater control.

        Try
            Dim ConnString As String = ConfigurationManager.ConnectionStrings("ConnectionString").ToString()
            Dim sql As String = "SELECT A.AssetID, A.AssetOwnID, A.AssetName, SUM(COALESCE(SumDeprication, 0)+COALESCE(IBDeprication, 0)) AS UBValue FROM Assets AS A LEFT OUTER JOIN (SELECT AssetID, SUM(DepricationValue) AS SumDeprication FROM Deprication WHERE YearID = @YearID GROUP BY AssetID) AS D ON A.AssetID = D.AssetID LEFT OUTER JOIN (SELECT AssetID, SUM(IBValue) AS IBDeprication FROM IBDeprication WHERE YearID = @YearID GROUP BY AssetID) AS IB ON A.AssetID = IB.AssetID WHERE A.CompanyID = @CompanyID AND SoldScraped = '0' GROUP BY A.AssetID, A.AssetOwnID, A.AssetName"

            ' The Using block is used to call dispose (close) automatically even if there are an exception.
            Using cn As New MySqlConnection(ConnString), _
                  cmd As New MySqlCommand(sql, cn)
                cmd.Parameters.Add("@CompanyID", MySqlDbType.Int64).Value = HiddenCompanyID.Value
                cmd.Parameters.Add("@YearID", MySqlDbType.Int64).Value = YearDropDown.SelectedValue

                cn.Open()
                ' The Using block is used to call dispose (close) automatically even if there are an exception.
                Using reader As MySqlDataReader = cmd.ExecuteReader()
                    AddAckAvskrRepeater.DataSource = reader
                    AddAckAvskrRepeater.DataBind()
                End Using

            End Using
        Catch ex As Exception
            Response.Write(ex.Message)
        End Try
    End Sub
    Protected Sub SaveIB_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles SaveIB.Click

        ' When the user clicks the button to save opening balance we look att each row in the repeater control
        ' and insert data if there is no corresponding post with AssetID and YearID in the table or update the
        ' post if there already are a post with the actual AssetID and YearID in the table.

        If Not HiddenYearID.Value = "" And Not HiddenCompanyID.Value = "" Then

            For Each RepeaterRow As RepeaterItem In AddAckAvskrRepeater.Items

                Dim AssetIDLiteralObj As Literal = DirectCast(RepeaterRow.FindControl("AssetIDLiteral"), Literal)
                Dim IBackAvskrivningarObj As TextBox = DirectCast(RepeaterRow.FindControl("IBackAvskrivningar"), TextBox)

                If Not IBackAvskrivningarObj.Text = "" Then
                    Try
                        Dim ConnString As String = ConfigurationManager.ConnectionStrings("ConnectionString").ToString()
                        Dim sql As String = "INSERT INTO IBDeprication (AssetID, YearID, IBValue) VALUES (@AssetID, @YearID, @IBValue)"

                        ' The Using block is used to call dispose (close) automatically even if there are an exception.
                        Using cn As New MySqlConnection(ConnString), _
                              cmd As New MySqlCommand(sql, cn)

                            cmd.Parameters.Add("@AssetID", MySqlDbType.Int64).Value = AssetIDLiteralObj.Text
                            cmd.Parameters.Add("@YearID", MySqlDbType.Int64).Value = HiddenYearID.Value
                            cmd.Parameters.Add("@IBValue", MySqlDbType.Decimal).Value = IBackAvskrivningarObj.Text
                            cn.Open()
                            cmd.ExecuteNonQuery()

                        End Using
                    Catch ex As MySqlException
                        Select Case ex.Number
                            Case 1062
                                Dim ConnString As String = ConfigurationManager.ConnectionStrings("ConnectionString").ToString()
                                Dim sql As String = "UPDATE IBDeprication SET IBValue = @IBValue WHERE AssetID = @AssetID AND YearID = @YearID"

                                ' The Using block is used to call dispose (close) automatically even if there are an exception.
                                Using cn As New MySqlConnection(ConnString), _
                                      cmd As New MySqlCommand(sql, cn)

                                    cmd.Parameters.Add("@AssetID", MySqlDbType.Int64).Value = AssetIDLiteralObj.Text
                                    cmd.Parameters.Add("@YearID", MySqlDbType.Int64).Value = HiddenYearID.Value
                                    cmd.Parameters.Add("@IBValue", MySqlDbType.Decimal).Value = IBackAvskrivningarObj.Text
                                    cn.Open()
                                    cmd.ExecuteNonQuery()

                                End Using
                            Case Else
                                Response.Write(ex.Message)
                        End Select
                    End Try
                End If
            Next
            Server.Transfer("New-page.aspx")
        Else
            ErrorLabel.Text = "* You have to select a company and accounting year"
        End If
    End Sub
End Class
